Attribute VB_Name = "MdlIniFile"
Option Explicit

Declare Function WritePrivateProfileString Lib "KERNEL32.DLL" Alias "WritePrivateProfileStringA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpString As Any, _
    ByVal lpFileName As String) As Long

Declare Function GetPrivateProfileString Lib "KERNEL32.DLL" Alias "GetPrivateProfileStringA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As Any, _
    ByVal lpDefault As String, _
    ByVal lpReturnedString As String, _
    ByVal nSize As Long, _
    ByVal lpFileName As String) As Long

Declare Function GetPrivateProfileInt Lib "KERNEL32.DLL" Alias "GetPrivateProfileIntA" ( _
    ByVal lpAppName As String, _
    ByVal lpKeyName As String, _
    ByVal nDefault As Long, _
    ByVal lpFileName As String) As Long
'
Declare Function PathRemoveFileSpec Lib "SHLWAPI.DLL" Alias "PathRemoveFileSpecA" ( _
    ByVal pszPath As String) As Long

Declare Function PathFindFileName Lib "SHLWAPI.DLL" Alias "PathFindFileNameA" ( _
    ByVal pszPath As String) As Long

Declare Sub MoveMemory Lib "kernel32" Alias "RtlMoveMemory" ( _
    pDest As Any, pSource As Any, ByVal ByteLen As Long)

Private Const MAX_PATH = 260
Private Const INI_FILE As String = ".\ANT_Chk.ini"

'*****************************************
'   Only API file pathname is taken out.
'*****************************************
Public Function RemoveFileSpec(ByVal strPath As String) As String
    ' strPath : full path(path name and file name)
    ' return  : paht name

    Dim lngResult As Long
    lngResult = PathRemoveFileSpec(strPath)
    If lngResult <> 0 Then
        If 0 < InStr(strPath, vbNullChar) Then
            RemoveFileSpec = Left$(strPath, InStr(strPath, vbNullChar) - 1)
        Else
            RemoveFileSpec = strPath
        End If
    End If
End Function

'********************************************
' Writes IP Address in ANT_Chk.ini
'********************************************
Public Sub WriteIniFile_IP_Adrs(ByVal Adrs As String)
    Dim ret As Long
    ret = WritePrivateProfileString("IP", "Address", Adrs, INI_FILE)
End Sub

'*********************************************
' Reads IP Address from ANT_Chk.ini
'*********************************************
Public Function ReadIniFile_IP_Adrs() As String
    Dim strSb As String
    Dim ret As Long
    
    strSb = "                "
    ret = GetPrivateProfileString("IP", "Address", "127.0.0.1", strSb, Len(strSb), INI_FILE)
    strSb = Replace(strSb, Chr(0), "")
    ReadIniFile_IP_Adrs = strSb
End Function

'*******************************************************
' Writes Save Setup Information Check Box in ANT_Chk.ini
'*******************************************************
Public Sub WriteIniFile_SaveInfo(ByVal strOnOff As String)
    Dim ret As Long
    ret = WritePrivateProfileString("Save", "Information", strOnOff, INI_FILE)
End Sub

'*********************************************************
' Reads Save Setup Information Check Box  from ANT_Chk.ini
'*********************************************************
Public Function ReadIniFile_SaveInfo() As String
    Dim strOnOff As String
    Dim ret As Long
    
    strOnOff = "0 "
    ret = GetPrivateProfileString("Save", "Information", "1", strOnOff, Len(strOnOff), INI_FILE)
    strOnOff = Replace(strOnOff, Chr(0), "")
    ReadIniFile_SaveInfo = strOnOff
End Function

'*********************************************
' Writes Setup File Dialog path in ANT_Chk.ini
'*********************************************
Public Sub WriteIniFile_SetupFileDlgPath(ByVal strFileDlgPath As String)
    Dim ret As Long
    ret = WritePrivateProfileString("FileDialog", "SetupPath", strFileDlgPath, INI_FILE)
End Sub

'********************************************
' Reads Setup File Dialog path in ANT_Chk.ini
'********************************************
Public Function ReadIniFile_SetupFileDlgPath() As String
    Dim strPath As String
    Dim ret As Long
    
    strPath = Replace(Space(512), " ", Chr(0))
    ret = GetPrivateProfileString("FileDialog", "SetupPath", App.path, strPath, Len(strPath), INI_FILE)
    strPath = Replace(strPath, Chr(0), "")
    ReadIniFile_SetupFileDlgPath = strPath
End Function


'******************************************************
' Writes Save Meas Data File Dialog path in ANT_Chk.ini
'******************************************************
Public Sub WriteIniFile_SvMsrDtFileDlgPath(ByVal strFileDlgPath As String)
    Dim ret As Long
    ret = WritePrivateProfileString("FileDialog", "SvMsrDtPath", strFileDlgPath, INI_FILE)
End Sub

'*****************************************************
' Reads Save Meas Data File Dialog path in ANT_Chk.ini
'*****************************************************
Public Function ReadIniFile_SvMsrDtFileDlgPath() As String
    Dim strPath As String
    Dim ret As Long
    
    strPath = Replace(Space(512), " ", Chr(0))
    ret = GetPrivateProfileString("FileDialog", "SvMsrDtPath", App.path, strPath, Len(strPath), INI_FILE)
    strPath = Replace(strPath, Chr(0), "")
    ReadIniFile_SvMsrDtFileDlgPath = strPath
End Function

